import static com.xebialabs.restito.builder.stub.StubHttp.whenHttp;
import static com.xebialabs.restito.semantics.Action.contentType;
import static com.xebialabs.restito.semantics.Action.resourceContent;
import static com.xebialabs.restito.semantics.Condition.endsWithUri;
import static com.xebialabs.restito.semantics.Condition.withPostBodyContaining;

import com.xebialabs.restito.server.StubServer;

public class MviMock extends AbstractMock {
    @Override
    public void run(StubServer server) {
        whenHttp(server).match(endsWithUri("/mockVAIdMPort"))
            .then(contentType("text/xml"), resourceContent("mvi-id-not-found.soap"));

        whenHttp(server).match(endsWithUri("/mockVAIdMPort"), withPostBodyContaining("D123401^NI^200DOD^USDOD"))
            .then(contentType("text/xml"), resourceContent("zztest_patient01_multi_dfn.soap"));

        whenHttp(server).match(endsWithUri("/mockVAIdMPort"), withPostBodyContaining("P001^NI^200DOD^USDOD"))
            .then(contentType("text/xml"), resourceContent("patient_one_single_dfn.soap"));
    }
}
